﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The patients controller.
    /// </summary>
    [Route("api/inventorylog")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class InventoryLogController : BaseController
    {
        /// <summary>
        /// the audit log service
        /// </summary>
        private readonly IInventoryLogService inventoryLogServices;

        /// <inheritdoc />
        public InventoryLogController(IInventoryLogService inventoryLogServices) => this.inventoryLogServices = inventoryLogServices;

        /// <summary>
        /// To fetch inventory logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of inventory logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of inventoryLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("fetch")]
        [ProducesResponseType(typeof(IEnumerable<InventoryLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> FetchAsync([FromBody] InventoryLogFilterModel model)
        {
            model = (InventoryLogFilterModel)EmptyFilter.Handler(model);
            var inventoryLogs = await inventoryLogServices.FetchAsync(model);
            if (inventoryLogs == null)
            {
                return ServerError();
            }

            return Success(inventoryLogs);
        }

        /// <summary>
        /// To insert inventory logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of inventory logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of inventoryLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>
        [HttpPost]
        [Authorize]
        [Route("insert")]
        [ProducesResponseType(500)]
        public async Task<int> InsertAsync([FromBody] InventoryLogModel model)
        {
            model = (InventoryLogModel)EmptyFilter.Handler(model);
            model.LogDate = DateTime.UtcNow;
            await inventoryLogServices.LogAsync(model);
            return 1;
        }
    }
}
